----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 2019/04/18 10:17:25
-- Design Name: 
-- Module Name: tb_main - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------
---------------------------------------------------------------------------------
-- This design is only for "educational" purpose. Not for product development or any commercial use.
-- This code and any related intellectual properties are under copy rights of Myway Plus Corporation
---------------------------------------------------------------------------------

------------------------------------------------------------------------
-- 1. Package declearation ---------------------------------------------
------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;


------------------------------------------------------------------------
-- 2. Entity declearation                  -----------------------------
------------------------------------------------------------------------
entity tb_main is
--  Port ( );
end tb_main;


------------------------------------------------------------------------
-- 3. Architecuture description                    ---------------------
------------------------------------------------------------------------
architecture Behavioral of tb_main is

-- 3-1. Component declearation used in this module ---------------------------------
component pwm_if
port(
        CLK_IN           : in std_logic;
RESET_IN        : in std_logic;
nPWM_UP_OUT    : out std_logic; --nUSER_OPT_OUT(0)
nPWM_UN_OUT    : out std_logic; --nUSER_OPT_OUT(1)
nPWM_VP_OUT    : out std_logic; --nUSER_OPT_OUT(2)
nPWM_VN_OUT    : out std_logic; --nUSER_OPT_OUT(3)
nPWM_WP_OUT    : out std_logic; --nUSER_OPT_OUT(4)
nPWM_WN_OUT    : out std_logic; --nUSER_OPT_OUT(5)

UPDATE    : in std_logic;
CARRIER   : in std_logic_vector (15 downto 0);
U_REF    : in std_logic_vector (15 downto 0);
V_REF    : in std_logic_vector (15 downto 0);
W_REF    : in std_logic_vector (15 downto 0);
DEADTIME : in std_logic_vector (12 downto 0);
GATE_EN  : in std_logic
);
end component;

-- 3-2. Signal declearation used in this module --------------------------------------
   constant CLK100M_period : time := 10 ns;
    signal	tb_clk       : std_logic := '0';
    signal  tb_reset       : std_logic := '0';
    signal  tb_pwm_up_n     : std_logic;
    signal  tb_pwm_un_n     : std_logic;
    signal  tb_pwm_vp_n     : std_logic;
    signal  tb_pwm_vn_n     : std_logic;
    signal  tb_pwm_wp_n     : std_logic;
    signal  tb_pwm_wn_n     : std_logic;
    signal  tb_pwm_others_n : std_logic_vector (23 downto 6);

    signal  tb_update     : std_logic;
    signal  tb_carrier   : std_logic_vector(15 downto 0);
    signal tb_u_ref    : std_logic_vector(15 downto 0);
    signal tb_v_ref    : std_logic_vector(15 downto 0);
    signal tb_w_ref    : std_logic_vector(15 downto 0);
    signal tb_deadtime : std_logic_vector(12 downto 0);
    signal tb_gate_en  : std_logic;

-- 3-3 Simulation description     --------------------------------------
begin

-- 3-3-1 module = DUT instanciation and port mapping     --------------------------------------
    u_pwm_if : pwm_if
        port map(
            CLK_IN           => tb_clk,
            RESET_IN        => tb_reset,
            nPWM_UP_OUT    => tb_pwm_up_n,
            nPWM_UN_OUT    => tb_pwm_un_n,
            nPWM_VP_OUT    => tb_pwm_vp_n,
            nPWM_VN_OUT    => tb_pwm_vn_n,
            nPWM_WP_OUT    => tb_pwm_wp_n,
            nPWM_WN_OUT    => tb_pwm_wn_n,

            UPDATE    => tb_update,
            CARRIER   => tb_carrier,
            U_REF    => tb_u_ref,
            V_REF    => tb_v_ref,
            W_REF    => tb_w_ref,
            DEADTIME => tb_deadtime,
            GATE_EN  => tb_gate_en
        );

-- 3-3-2  Clock process description     --------------------------------------
   CLK50M_process :process
   begin
		tb_clk <= '0';
		wait for CLK100M_period/2;
		tb_clk <= '1';
		wait for CLK100M_period/2;
   end process;
   
 -- 3-3-3  Stimulus process description     --------------------------------------
   stim_proc: process
   begin      
   tb_reset         <= '1';
   
   tb_update      <= '1';
   tb_carrier    <= X"1388"; -- 10kHz
   tb_u_ref      <= X"09C4";
   tb_v_ref      <= X"09C4";
   tb_w_ref      <= X"09C4";
   tb_deadtime   <=  '0' & X"190";
   tb_gate_en    <= '1';
 
wait for 100ns;

   tb_reset         <= '0';


wait for 200us; 
   tb_u_ref      <= X"04E2";
   tb_v_ref      <= X"0AC4";
   tb_w_ref      <= X"06C4";   

wait for 200us; 
--   tb_carrier    <= X"094c"; -- 20kHz

   
wait;  
   
end process;

end Behavioral;
